﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="QUESTInstrument.aspx.cs"
    Inherits="TBI_Instruments_QUESTInstrument" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register TagPrefix="VA" TagName="TechDeviceSelector" Src="~/controls/TechDeviceSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }
            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable buttons during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }

        function endRequest(sender, e) {
            //re-enable buttons once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
        }
    </script>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            $(document).ready(function () {
                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function (e) {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                }
            }); // END $(document).ready(function()

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }
                return ret;
            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;
                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Quebec User Evaluation of Satisfaction with Assistive Technology"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server" ChildrenAsTriggers="true">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="QUEST" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width: 800px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                The purpose of the QUEST questionnaire is to evaluate how satisfied you are with your assistive device and the related services
                                you experienced. The questionnaire consists of 12 satisfaction items.
                                <br />
                                For each of the 12 items, rate your satisfaction with your assistive device and the related services you experienced by
                                using the following scale of 1 to 5:
                                <br />
                                1 = "Not satisfied at all"
                                <br />
                                2 = "Not very satisfied"
                                <br />
                                3 = "More or less satisfied"
                                <br />
                                4 = "Quite satisfied"
                                <br />
                                5 = "Very satisfied"
                                <br />
                                For any item that you were not "very satisfied", please comment in the section <b>comments</b>.
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td colspan="4">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="5">
                                </asp:Label> <span class="requiredField">*</span>
                                <br />
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="6">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <br />
                                <!--TechDev-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelTechDev" runat="server" AssociatedControlID="txtTechDev" SkinID="DataLabel" TabIndex="17">
                                </asp:Label><br />
                                <asp:TextBox runat="server" ID="txtTechDev" Width="320px" TabIndex="18"></asp:TextBox>
                                <br />
                                <!--Question TechDev Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorTechDev" runat="server" ControlToValidate="txtTechDev" TabIndex="18" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Device is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <h3>
                                    Assistive Device</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <b>How satisfied are you with...</b>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                1.
                            </td>
                            <td colspan="2">
                                <!--the dimensions (size, height, length, width) of your assistive device?-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="25">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 1 Choice List -->
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion1" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="26">
                                </asp:RadioButtonList>
                                <!--Question 1 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="27" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 1 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion1" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 1 Question Number-->
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--Comments 1-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor1Comment" runat="server" AssociatedControlID="txtComments1" SkinID="DataLabel" TabIndex="28">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments1" runat="server" TextMode="MultiLine" Width="400px" TabIndex="29"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                2.
                            </td>
                            <td colspan="2">
                                <!--the dimensions (size, height, length, width) of your assistive device?-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="30">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 2 Choice List -->
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion2" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="31">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 2 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion2" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 2 Question Number-->
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--Comments 2-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor2Comment" runat="server" AssociatedControlID="txtComments2" SkinID="DataLabel" TabIndex="33">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments2" runat="server" TextMode="MultiLine" Width="400px" TabIndex="34"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                3.
                            </td>
                            <td colspan="2">
                                <!-- the ease in adjusting (fixing, fastening) the parts of your assistive device?-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="35">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 3 Choice List -->
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion3" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="36">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="37" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 3 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion3" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 3 Question Number-->
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--3Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor3Comment" runat="server" AssociatedControlID="txtComments3" SkinID="DataLabel" TabIndex="38">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments3" runat="server" TextMode="MultiLine" Width="400px" TabIndex="39"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                4.
                            </td>
                            <td colspan="2">
                                <!-- how safe and secure your assistive device is?-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="40">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 4 Choice List -->
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion4" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="41">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="42" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 4 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion4" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 4 Question Number-->
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--4Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor4Comment" runat="server" AssociatedControlID="txtComments4" SkinID="DataLabel" TabIndex="43">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments4" runat="server" TextMode="MultiLine" Width="400px" TabIndex="44"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                5.
                            </td>
                            <td colspan="2">
                                <!-- the durability (endurance, resistance to wear) of your assistive device?-->
                                <!-- LabelForQ5 Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="45">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 5 Choice List -->
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion5" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="46">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="47" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 5 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion5" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 5 Question Number-->
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--5Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor5Comment" runat="server" AssociatedControlID="txtComments5" SkinID="DataLabel" TabIndex="48">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments5" runat="server" TextMode="MultiLine" Width="400px" TabIndex="49"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                6.
                            </td>
                            <td colspan="2">
                                <!-- how easy it is to user your assistive device?-->
                                <!-- LabelForQ6 Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="50">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 6 Choice List -->
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion6" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="51">
                                </asp:RadioButtonList>
                                <!--Question 6 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="52" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 6 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion6" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 6 Question Number-->
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--6Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor6Comment" runat="server" AssociatedControlID="txtComments6" SkinID="DataLabel" TabIndex="53">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments6" runat="server" TextMode="MultiLine" Width="400px" TabIndex="54"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                7.
                            </td>
                            <td colspan="2">
                                <!-- how comfortable your assistive device is?-->
                                <!-- LabelForQ7 Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="55">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 7 Choice List -->
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion7" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="56">
                                </asp:RadioButtonList>
                                <!--Question 7 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="57" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 7 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion7" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 7 Question Number-->
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--7Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor7Comment" runat="server" AssociatedControlID="txtComments7" SkinID="DataLabel" TabIndex="58">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments7" runat="server" TextMode="MultiLine" Width="400px" TabIndex="59"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                8.
                            </td>
                            <td colspan="2">
                                <!-- how effective your assistive device is (the degree to which your device meets your needs)?-->
                                <!-- LabelForQ8 Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="60">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 8 Choice List -->
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion8" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="61">
                                </asp:RadioButtonList>
                                <!--Question 8 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="62" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 8 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion8" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 8 Question Number-->
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--8Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor8Comment" runat="server" AssociatedControlID="txtComments8" SkinID="DataLabel" TabIndex="63">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments8" runat="server" TextMode="MultiLine" Width="400px" TabIndex="64"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <h3>
                                    Services</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <b>How satisfied are you with...</b>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                9.
                            </td>
                            <td colspan="2">
                                <!-- the service delivery program (procedures, length of time) in which your obtained your assistive device?-->
                                <!-- LabelForQ9 Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="65">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 9 Choice List -->
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion9" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="66">
                                </asp:RadioButtonList>
                                <!--Question 9 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="67" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 9 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion9" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 9 Question Number-->
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--9Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor9Comment" runat="server" AssociatedControlID="txtComments9" SkinID="DataLabel" TabIndex="68">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments9" runat="server" TextMode="MultiLine" Width="400px" TabIndex="69"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                10.
                            </td>
                            <td colspan="2">
                                <!-- the repairs and servicing (maintenance) provided for your assistive device?-->
                                <!-- LabelForQ10 Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="70">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 10 Choice List -->
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion10" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="71">
                                </asp:RadioButtonList>
                                <!--Question 10 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="72" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 10 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion10" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 10 Question Number-->
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--10Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor10Comment" runat="server" AssociatedControlID="txtComments10" SkinID="DataLabel" TabIndex="73">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments10" runat="server" TextMode="MultiLine" Width="400px" TabIndex="74"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                11.
                            </td>
                            <td colspan="2">
                                <!-- the quality of the professional services (information, attention) your received for using your assistive device?-->
                                <!-- LabelForQ11 Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="75">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 11 Choice List -->
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion11" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="76">
                                </asp:RadioButtonList>
                                <!--Question 11 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="77" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 11 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion11" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 11 Question Number-->
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--11Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor11Comment" runat="server" AssociatedControlID="txtComments11" SkinID="DataLabel" TabIndex="78">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments11" runat="server" TextMode="MultiLine" Width="400px" TabIndex="79"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;" rowspan="2">
                                12.
                            </td>
                            <td colspan="2">
                                <!-- the follow-up services (continuing support services) received for your assistive device?-->
                                <!-- LabelForQ12 Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="80">
                                </asp:Label>
                            </td>
                            <td style="width: 160px;" rowspan="2">
                                <!-- Question 12 Choice List -->
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQuestion12" DataTextField="CHOICE_NAME"
                                    DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="81">
                                </asp:RadioButtonList>
                                <!--Question 12 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorTOE" runat="server" ControlToValidate="rblQ12" TabIndex="82" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!-- Question 12 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion12" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 12 Question Number-->
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px;">
                                <!--12Comment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor12Comment" runat="server" AssociatedControlID="txtComments12" SkinID="DataLabel" TabIndex="83">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtComments12" runat="server" TextMode="MultiLine" Width="400px" TabIndex="84"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                    <table style="width: 800px;">
                        <tr>
                            <td colspan="3">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Question 13: Below is the list of the same 12 satisfaction items. PLEASE SELECT THE THREE ITEMS that you consider to be the most important to you.  Please put an X in the 3 boxes of your choice. -->
                                <!-- LabelForQ13 Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="cblImportantItemsQ13" SkinID="DataLabel" TabIndex="85">
                                </asp:Label>
                                <br />
                                <!-- Question 13 Choice List -->
                                <asp:CheckBoxList ID="cblImportantItemsQ13" runat="server" RepeatColumns="3" Width="600px" DataSourceID="ObjectDataSourceQuestion13"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="86" OnDataBound="cblImportantItemsQ13_DataBound">
                                </asp:CheckBoxList>
                                <!-- Custom Validation Error -->
                                <asp:Label ID="lblImportantItemsError" runat="server" Font-Bold="true" ForeColor="Red" Visible="false" TabIndex="87" />
                                <!-- Question 13 Object Data Source -->
                                <asp:ObjectDataSource ID="ObjectDataSourceQuestion13" runat="server" 
                                    SelectMethod="GetQuestionChoices" TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 13 Question Number-->
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" CausesValidation="true" Text="Save Draft" Width="130px"
                    OnClick="btnSaveSurveyDraft_Click" ValidationGroup="OnSaveDraft" TabIndex="88" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="89" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="90" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>